Story = copy_table(BaseView)
Story.definition = "story"

Story.stories = {
    story1 = {
        {
            title = { x = 246, y = 108, text = str.story1_title},
            author = { x = 246, y = 150, text = str.story1_author},
            story_left = { x = 105, y = 190, text = str.story1al},
            story_right = { x = 425, y = 105, text = str.story1ar},
        },

        {
            story_left = { x = 105, y = 105, text = str.story1bl},
            story_right = { x = 425, y = 105, text = str.story1br},
        },

        {
            story_left = { x = 105, y = 105, text = str.story1cl},
            story_right = { x = 425, y = 105, text = str.story1cr},
        },

        {
            picture = { x = 80, y = 105, bitmap = "gfx/story/photo_megan" },
            bio = { x = 400, y = 95, w = 320, text = str.bio_megan},
            website = { x = 250, y = 350, link = "http://www.meganhart.com" },
        },
    },

    story2 = {
        {
            title = { x = 246, y = 108, text = str.story2_title},
            author = { x = 246, y = 150, text = str.story2_author},
            story_left = { x = 105, y = 190, text = str.story2al},
            story_right = { x = 425, y = 105, text = str.story2ar},
        },

        {
            story_left = { x = 105, y = 105, text = str.story2bl},
            story_right = { x = 425, y = 105, text = str.story2br},
        },

        {
            story_left = { x = 105, y = 105, text = str.story2cl},
            story_right = { x = 425, y = 105, text = str.story2cr},
        },
        
        {
            story_left = { x = 105, y = 105, text = str.story2dl},
            --story_right = { x = 425, y = 105, text = str.story2dr},
        },

        {
            picture = { x = 115, y = 112, bitmap = "gfx/story/photo_natalie" },
            bio = { x = 425, y = 150, text = str.bio_natalie},
            website = { x = 250, y = 350, link = "http://www.nataliedamschroder.com" },
        },
    },
    
    story3 = {
        {
            title = { x = 246, y = 108, text = str.story3_title},
            author = { x = 246, y = 150, text = str.story3_author},
            story_left = { x = 105, y = 190, text = str.story3al},
            story_right = { x = 425, y = 105, text = str.story3ar},
        },

        {
            story_left = { x = 105, y = 105, text = str.story3bl},
            story_right = { x = 425, y = 105, text = str.story3br},
        },

        {
            story_left = { x = 105, y = 105, text = str.story3cl},
            story_right = { x = 425, y = 105, text = str.story3cr},
        },

        {
            picture = { x = 112, y = 95, bitmap = "gfx/story/photo_misty" },
            bio = { x = 400, y = 95, w = 320, text = str.bio_misty},
            website = { x = 250, y = 390, link = "http://www.mistysimon.com" },
        },
    },

    story4 = {
        {
            title = { x = 246, y = 108, text = str.story4_title},
            author = { x = 246, y = 150, text = str.story4_author},
            story_left = { x = 105, y = 190, text = str.story4al},
            story_right = { x = 425, y = 105, text = str.story4ar},
        },

        {
            story_left = { x = 105, y = 105, text = str.story4bl},
            story_right = { x = 425, y = 105, text = str.story4br},
        },

        {
            story_left = { x = 105, y = 105, text = str.story4cl},
            story_right = { x = 425, y = 105, text = str.story4cr},
        },
        
        {
            picture = { x = 130-14+35, y = 85+27, bitmap = "gfx/story/photo_victoria" },
            bio = { x = 400, y = 135, text = str.bio_victoria},
            website = { x = 250, y = 390, link = "http://vickismith.blogspot.com" },
        },
    },

    story5 = {
        {
            title = { x = 246, y = 108, text = str.story5_title},
            author = { x = 246, y = 150, text = str.story5_author},
            story_left = { x = 105, y = 190, text = str.story5al},
            story_right = { x = 425, y = 105, text = str.story5ar},
        },

        {
            story_left = { x = 105, y = 105, text = str.story5bl},
            story_right = { x = 425, y = 105, text = str.story5br},
        },

        {
            story_left = { x = 105, y = 105, text = str.story5cl},
            story_right = { x = 425, y = 105, text = str.story5cr},
        },
        
        {
            picture = { x = 130, y = 85, bitmap = "gfx/story/photo_kimber" },
            bio = { x = 400, y = 135, w = 320, text = str.bio_kimber},
            website = { x = 250, y = 390, link = "http://businessromance.com" },
        },
    },

    story6 = {
        {
            title = { x = 246, y = 108, text = str.story6_title},
            author = { x = 246, y = 150, text = str.story6_author},
            story_left = { x = 105, y = 190, text = str.story6al},
            story_right = { x = 425, y = 105, text = str.story6ar},
        },

        {
            story_left = { x = 105, y = 105, text = str.story6bl},
            story_right = { x = 425, y = 105, text = str.story6br},
        },

        {
            story_left = { x = 105, y = 105, text = str.story6cl},
            story_right = { x = 425, y = 105, text = str.story6cr},
        },

        {
            story_left = { x = 105, y = 105, text = str.story6dl},
            story_right = { x = 425, y = 105, text = str.story6dr},
        },
        
        {
            picture = { x = 75, y = 110, bitmap = "gfx/story/photo_dee" },
            bio = { x = 385, y = 95, w = 340, text = str.bio_dee},
            website = { x = 250, y = 390, link = "http://www.deetenorio.com" },
        },
    },

    story7 = {
        {
            title = { x = 246, y = 108, text = str.story7_title},
            author = { x = 246, y = 150, text = str.story7_author},
            story_left = { x = 105, y = 190, text = str.story7al},
            story_right = { x = 425, y = 105, text = str.story7ar},
        },

        {
            story_left = { x = 105, y = 105, text = str.story7bl},
            story_right = { x = 425, y = 105, text = str.story7br},
        },

        {
            story_left = { x = 105, y = 105, text = str.story7cl},
            story_right = { x = 425, y = 105, text = str.story7cr},
        },

        {
            story_left = { x = 105, y = 105, text = str.story7dl},
            story_right = { x = 425, y = 105, text = str.story7dr},
        },
        
        {
            picture = { x = 112, y = 95, bitmap = "gfx/story/photo_sherry" },
            bio = { x = 400, y = 95, w = 320, text = str.bio_sherry},
            website = { x = 250, y = 370, link = "http://www.sherrythomas.com" },
        },
    },

}


function Story:init(options)
    BaseView.init(self)
    self.ani = Animator:new(true)
    self.ani:key("right_x", { {0, self.shortcuts.right.x}, {0.5, self.shortcuts.right.x + 5}, {1, self.shortcuts.right.x} } )
    self.ani:key("left_x", { {0, self.shortcuts.left.x}, {0.5, self.shortcuts.left.x - 5}, {1, self.shortcuts.left.x} } )
    self.ani:key("color", { {0, 0}, {0.5, 1}, {1, 0} } )

    self.story = self.stories[options.story_name]
    self.page = 1
    self:prepare_page(self.page)
    
    snd_play_music("music/hearts.ogg")
end


function Story:update(dt)
    BaseView.update(self, dt)
    self.ani:update(dt)
    self.shortcuts.left.x = self.ani.val.left_x
    self.shortcuts.left.color = gfx_color(self.ani.val.color, self.ani.val.color, self.ani.val.color)
    self.shortcuts.right.x = self.ani.val.right_x
    self.shortcuts.right.color = gfx_color(self.ani.val.color, self.ani.val.color, self.ani.val.color)

    if self.fade then
        self.fade:update(dt)
        local alpha = self.fade.val.alpha
        
        if self.fade:is_finished() then
            self.fade = nil
            if self.dest_page then
                alpha = 0
                self.page = self.dest_page
                self.dest_page = nil
                self:prepare_page(self.page)
                self:refresh_ui()
                self.fade = Animator:new()
                self.fade:key("alpha", { {0, 0}, {0.5, 1} } )
            else
                alpha = 1
            end
        end
        
        for i,v in ipairs(self.objects) do
            if v.is_page then
                v.alpha = alpha
            end
        end
    end
end


function Story:prepare_page(id)
    local page = self.story[id]
    local def, o
    
    for i,v in ipairs(self.objects) do
        if v.is_page then
            v.to_destroy = true
        end
    end
    
    if page.title then
        def = {
            type = "Bitmap",
            bitmap = "gfx/story/chapter_frame",
            x = 125, y = 78, z = 9,
        }
        o = self:create_and_add_object(def, false)
        o.is_page = true

        def = {
            type = "Text",
            font = "story15",
            text = page.title.text,
            x = page.title.x, y = page.title.y, z = 10,
            w = 144,
            align = "center vcenter",
            color = "000000",
        }
        o = self:create_and_add_object(def, false)
        o.is_page = true
    end

    if page.author then
        def = {
            type = "Text",
            font = "story15",
            text = page.author.text,
            x = page.author.x, y = page.author.y, z = 10,
            align = "center vcenter",
            color = "000000",
        }
        o = self:create_and_add_object(def, false)
        o.is_page = true
    end

    if page.story_left then
        def = {
            type = "Text",
            font = "story15",
            text = page.story_left.text,
            x = page.story_left.x, y = page.story_left.y, z = 10,
            w = 290,
            color = "000000",
        }
        o = self:create_and_add_object(def, false)
        o.is_page = true
    end

    if page.story_right then
        def = {
            type = "Text",
            font = "story15",
            text = page.story_right.text,
            x = page.story_right.x, y = page.story_right.y, z = 10,
            w = 290,
            color = "000000",
        }
        o = self:create_and_add_object(def, false)
        o.is_page = true
    end

    if page.bio then
        def = {
            type = "Text",
            font = "story15",
            text = page.bio.text,
            x = page.bio.x, y = page.bio.y, z = 10,
            w = page.bio.w or 290,
            --align = "center",
            color = "000000",
        }
        
        o = self:create_and_add_object(def, false)
        o.is_page = true
    end

    if page.picture then
        def = {
            type = "Bitmap",
            bitmap = page.picture.bitmap,
            x = page.picture.x, y = page.picture.y, z = 9,
        }
        o = self:create_and_add_object(def, false)
        o.is_page = true
    end
    
    if page.website then
        def = {
            type = "Text",
            font = "story15",
            text = str.bio_website_click,
            x = page.website.x, y = page.website.y, z = 10,
            w = 200,
            align = "center",
            color = "000000",
        }
        o = self:create_and_add_object(def, false)
        o.is_page = true

        def = {
            type = "LabeledButton",
            bitmap = "gfx/button_std",
            bitmap_hi = "gfx/button_std_hi",
            shortcut = "button",
            x = page.website.x, y = page.website.y + 60, z = 10,
            text = str.bio_website_button,
            mouse_click = "website_button",
            extra = page.website.link,
        }

        o = self:create_and_add_object(def, false)
        o.is_page = true
    end


    self:sort_objects()
    self:refresh_ui()
end


function Story:main_button()
    if not self.fade then
        fw:change_view(StorySelector, nil, "blend")
    end
end


function Story:right_button()
    if not self.fade then
        self.dest_page = self.page + 1
        self.fade = Animator:new()
        self.fade:key("alpha", { {0, 1}, {0.5, 0} } )
        snd_play_sound("book_page_flip")
    end
end


function Story:left_button()
    if not self.fade then
        self.dest_page = self.page - 1
        self.fade = Animator:new()
        self.fade:key("alpha", { {0, 1}, {0.5, 0} } )
        snd_play_sound("book_page_flip")
    end
end


function Story:refresh_ui()
    if not self.story[self.page - 1] then
        self.shortcuts.left.enabled = false
    else
        self.shortcuts.left.enabled = true
    end

    if not self.story[self.page + 1] then
        self.shortcuts.right.enabled = false
    else
        self.shortcuts.right.enabled = true
    end
end


function Story:website_button(obj)
    net_open_web(obj.extra)
end
